include ${RSAT}/makefiles/util.mk
MAKEFILE=scripts/makefiles/patch.mk


besnard_vs_ns3:
	compare-features -v 2 \
		-iformat bed \
		-return stats \
		-i analysis/peaks/SWEMBL/SWEMBL_Besnard_SRR494094+95_vs_s_8_Genomique_1_R0.002/SWEMBL_Besnard_SRR494094+95_vs_s_8_Genomique_1_R0.002_peaks_sorted.bed \
		-i analysis/peaks/SWEMBL/SWEMBL_s_7_NS3_vs_s_8_Genomique_1_R0.002/SWEMBL_s_7_NS3_vs_s_8_Genomique_1_R0.002_peaks_sorted.bed \
		-o hs_besnard_vs_ns3_SWEMBL_peak_comparison.tab

it:
	compare-features -v 2 \
		-iformat bed \
		-return stats \
		-i analysis/peaks/SICER/s_7_NS3_vs_s_8_Genomique_1_SICER/s_7_NS3-W200-G600-FDR0.01-island.bed \
		-i analysis/peaks/SICER/Besnard_SRR494094+95_vs_s_8_Genomique_1_SICER/Besnard_SRR494094+95-W200-G600-FDR0.01-island.bed \
		-o hs_besnard_vs_ns3_SICER_peak_comparison.tab


done:
	make -f makefiles/01_peak_calling.mk  ANALYSIS=Besnard_SRR494094+95_vs_s_8_Genomique_1 macs_post_treatment
	make -f makefiles/01_peak_calling.mk  ANALYSIS=BN3_vs_input macs_post_treatment ; \
	make -f makefiles/01_peak_calling.mk  ANALYSIS=ES_C3_vs_input macs_post_treatment ; \
	make -f makefiles/01_peak_calling.mk  ANALYSIS=ES_indiff_C3_BN_vs_input macs_post_treatment

link_reads:
	ln -fs data/reads/Besnard_SRR494093_sorted.bed data/reads/Besnard_SRR494093.bed
	ln -fs data/reads/Besnard_SRR494094_sorted.bed data/reads/Besnard_SRR494094.bed
	ln -fs data/reads/Besnard_SRR494095_sorted.bed data/reads/Besnard_SRR494095.bed
	ln -fs data/reads/ES_indiff_sorted.bed data/reads/ES_indiff.bed
	ln -fs data/reads/F4_CGR8_sorted.bed data/reads/F4_CGR8.bed
	ln -fs data/reads/F4_ES_RA_sorted.bed data/reads/F4_ES_RA.bed
	ln -fs data/reads/F4_PN_sorted.bed data/reads/F4_PN.bed
	ln -fs data/reads/F4_RNAse_sorted.bed data/reads/F4_RNAse.bed
	ln -fs data/reads/HF_RNAse_sorted.bed data/reads/HF_RNAse.bed
	ln -fs data/reads/input_sorted.bed data/reads/input.bed
	ln -fs data/reads/s_1_ES_19H_sorted.bed data/reads/s_1_ES_19H.bed
	ln -fs data/reads/s_3_NP_sorted.bed data/reads/s_3_NP.bed
	ln -fs data/reads/s_5_NS1_sorted.bed data/reads/s_5_NS1.bed
	ln -fs data/reads/s_7_NS3_sorted.bed data/reads/s_7_NS3.bed
	ln -fs data/reads/s_8_Genomique_1_sorted.bed data/reads/s_8_Genomique_1.bed

mv_sorted:
	mv -f data/reads/Besnard_SRR494093_sorted.bed data/reads/Besnard_SRR494093.bed
	mv -f data/reads/Besnard_SRR494094_sorted.bed data/reads/Besnard_SRR494094.bed
	mv -f data/reads/Besnard_SRR494095_sorted.bed data/reads/Besnard_SRR494095.bed
	mv -f data/reads/ES_indiff_sorted.bed data/reads/ES_indiff.bed
	mv -f data/reads/F4_CGR8_sorted.bed data/reads/F4_CGR8.bed
	mv -f data/reads/F4_ES_RA_sorted.bed data/reads/F4_ES_RA.bed
	mv -f data/reads/F4_PN_sorted.bed data/reads/F4_PN.bed
	mv -f data/reads/F4_RNAse_sorted.bed data/reads/F4_RNAse.bed
	mv -f data/reads/HF_RNAse_sorted.bed data/reads/HF_RNAse.bed
	mv -f data/reads/input_sorted.bed data/reads/input.bed
	mv -f data/reads/s_1_ES_19H_sorted.bed data/reads/s_1_ES_19H.bed
	mv -f data/reads/s_3_NP_sorted.bed data/reads/s_3_NP.bed
	mv -f data/reads/s_5_NS1_sorted.bed data/reads/s_5_NS1.bed
	mv -f data/reads/s_7_NS3_sorted.bed data/reads/s_7_NS3.bed
	mv -f data/reads/s_8_Genomique_1_sorted.bed data/reads/s_8_Genomique_1.bed

## The bowtie indexes contain random chromosomes, I don't know why. I
## guess this aims to be used as negative control but, consequently, I
## have reads and peaks in random chromosomes.
## > 1% of the reads map on these random chromosomes
##
## TEMPORARY FIX: I suppress random reads from the bed file.
## Should later be checked at the root (the bowtie2 indexes)
no_random_in_my_bed:
	wc -l data/reads/Besnard_SRR494094_sorted.bed; grep -v  random data/reads/Besnard_SRR494094_sorted.bed > boum; mv boum data/reads/Besnard_SRR494094_sorted.bed; wc -l data/reads/Besnard_SRR494094_sorted.bed
	wc -l data/reads/Besnard_SRR494095_sorted.bed; grep -v  random data/reads/Besnard_SRR494095_sorted.bed > boum; mv boum data/reads/Besnard_SRR494095_sorted.bed; wc -l data/reads/Besnard_SRR494095_sorted.bed
	wc -l data/reads/Besnard_SRR494093_sorted.bed; grep -v  random data/reads/Besnard_SRR494093_sorted.bed > boum; mv boum data/reads/Besnard_SRR494093_sorted.bed; wc -l data/reads/Besnard_SRR494093_sorted.bed


done_jolitorax:
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task clusters,index' POS_CLUST_NB=10 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task clusters,index' POS_CLUST_NB=9 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task clusters,index' POS_CLUST_NB=8 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task clusters,index' POS_CLUST_NB=7 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task clusters,index' POS_CLUST_NB=6 WHEN=queue
	@echo "Re-indexing positions"
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task index'

to_do_jolitorax:
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task index'
	make -f makefiles/synchro.mk publish DIR=analysis/motifs
	make -f makefiles/synchro.mk publish DIR=analysis/peaks
	make -f makefiles/09_index_results.mk index
	make -f makefiles/synchro.mk publish DIR=html

later_jolitorax:
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task matrices' POS_CLUST_NB=10 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task matrices' POS_CLUST_NB=9 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task matrices' POS_CLUST_NB=8 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task matrices' POS_CLUST_NB=7 WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk origins_all_positions OPT='-task matrices' POS_CLUST_NB=6 WHEN=queue
