################################################################
## Analyze the nascent strands sequences (NS-seq) to detect
## replication origins and associated motifs.
##
## Data from Christelle Cayrou and Marcel Mechali.
## Analysis by Benoid Ballester and Jacques van Helden.
##
## This script recapitulates the commands used for the final analysis.

ANALYSIS=ES_indiff_C3_BN_vs_F4_RNAse
SWEMBL_R=0.002

################################################################
## We run peak calling with 3 programs, which return different pieces
## of information:
##
## SWEMBL detects narrow peaks likely to correspond to origins.
##
## SICER detects large regions encompassing several peaks, which may
## correspond to origin clusters.
##
## MACS reports somewhat intermediate results: individual peaks or
## regions encompassing a few peaks. MACS regions are further
## subdivided into individual peaks using PeakSplitter.
peak_calling:
	@${MAKE} -f makefiles/01_peak_calling.mk swembl WHEN=queue
	@${MAKE} -f makefiles/01_peak_calling.mk macs WHEN=queue
	@${MAKE} -f makefiles/01_peak_calling.mk sicer sicer_threshold_series 

clean_sicer:
	@${MAKE} -f makefiles/01_peak_calling.mk sicer_clean

################################################################
## Generate negative control sets
##
## 1. Select random peaks of the same sizes as the peaks
## 2. Generate random sequences of the same sizes as the peaks
rand_peaks:
	@${MAKE} -f makefiles/01_peak_calling.mk random_swembl_summits
## NOT WORKING ANYMORE, TO BE CHECKED	@${MAKE} -f makefiles/01_peak_calling.mk randseq_swembl_summits

motifs:
	@${MAKE} -f makefiles/02_motifs.mk positions_all_lengths POS_TASK=positions_markov_swembl_summits POS_MKV=-2 POS_OLIGO_LENGTHS='2 3 4 5 6 7 8' WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk positions_all_lengths POS_TASK=positions_markov_swembl_summits POS_MKV=0 POS_OLIGO_LENGTHS='2 3 4 5 6 7 8' WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk positions_all_lengths POS_TASK=positions_swembl_summits POS_OLIGO_LENGTHS='1 2 3 4 5 6 7 8'  WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk positions_all_lengths POS_TASK=positions_markov_rand_swembl_peak_summits POS_MKV=-2 POS_OLIGO_LENGTHS='2 3 4 5 6 7 8'  WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk positions_all_lengths POS_TASK=positions_markov_rand_swembl_peak_summits POS_MKV=0 POS_OLIGO_LENGTHS='2 3 4 5 6 7 8'  WHEN=queue
	@${MAKE} -f makefiles/02_motifs.mk positions_all_lengths POS_TASK=positions_rand_swembl_peak_summits  POS_OLIGO_LENGTHS='1 2 3 4 5 6 7 8'  WHEN=queue



