################################################################
## Parameters for the analysis of Mechali's chip-seq data on replication
## origins.

include scripts/makefiles/00_config.mk

##CHROM_ORG=Homo_sapiens
CHROM_ORG=Mus_musculus
include scripts/makefiles/00_chrom_${CHROM_ORG}.mk


## Directories
MAIN=$PWD
DIR_READS=data/reads

################################################################
## use nice mode for heavy computational processes
NICE=nice -n 20


################################################################
## Analysis-specific parameters
ANALYSIS_TABLE=analysis/analyses_descriptions.tab
#ANALYSIS=ES_indiff_vs_F4_RNAse
#ANALYSIS=Besnard_SRR494093_vs_s_8_Genomique_1
#ANALYSIS=Besnard_SRR494094+95_vs_s_8_Genomique_1
#ANALYSIS=ES_indiff_C3_BN_vs_input
ANALYSIS=ES_indiff_C3_BN_vs_F4_RNAse
#ANALYSIS=s_7_NS3_vs_s_8_Genomique_1
ANALYSES = `grep -v '\#' ${ANALYSIS_TABLE} | awk '$$3 != ""' | grep -v '^;' | cut -f 3 | xargs`
TEST=`awk -F'\t' '$$3 == "${ANALYSIS}" {print $$1}' ${ANALYSIS_TABLE}`
CTRL=`awk -F'\t' '$$3 == "${ANALYSIS}" {print $$2}' ${ANALYSIS_TABLE}`
ORGANISM=`awk -F'\t' '$$3 == "${ANALYSIS}" {print $$5}' ${ANALYSIS_TABLE} | head -1`
GENOME=`awk -F'\t' '$$3 == "${ANALYSIS}" {print $$6}' ${ANALYSIS_TABLE} | head -1`
ANALYSIS_DESCR=`awk -F'\t' '$$3 == "${ANALYSIS}" {print $$7}' ${ANALYSIS_TABLE} | head -1`


################################################################
## Sample-specific parameters
SAMPLE_TABLE=data/sample_descriptions.tab
#ORGANISM=`awk -F'\t' '$$1 == "${TEST}" {print $$4}' ${ANALYSIS_TABLE} | head -1`
#GENOME=`awk -F'\t' '$$1 == "${TEST}" {print $$5}' ${ANALYSIS_TABLE} | head -1`
ALIAS=`awk -F'\t' '$$1 == "${TEST}" {print $$6}' ${SAMPLE_TABLE} | head -1`
CELL_TYPE=`awk -F'\t' '$$1 == "${TEST}" {print $$7}' ${SAMPLE_TABLE} | head -1`
TREATMENT=`awk -F'\t' '$$1 == "${TEST}" {print $$8}' ${SAMPLE_TABLE} | head -1`
SAMPLE_DESCR=`awk -F'\t' '$$1 == "${TEST}" {print $$9}' ${SAMPLE_TABLE} | head -1`

## Read organism-specific parameters
#include makefiles/00_param_${ORGANISM}.mk

## Read files (not sorted)
TEST_READS=${DIR_READS}/${TEST}.bed
CTRL_READS=${DIR_READS}/${CTRL}.bed
READS=${TEST_READS}

## SWEMBL requires sorted reads
#TEST_READS_SORTED=${DIR_READS}/${TEST}_sorted.bed
#CTRL_READS_SORTED=${DIR_READS}/${CTRL}_sorted.bed

## Identify test read files
#TEST_READ_FILES=`ls -1 ${DIR_READS}/*.bed | grep -v ${CTRL}.bed | grep -v _sorted `
#TEST_READ_NAMES=`ls -1 ${DIR_READS}/*.bed | grep -v ${CTRL}.bed | grep -v _sorted | perl -pe 's|${DIR_READS}/||g' | perl -pe 's|\.bed||g' `

READ_FILES=`grep -v '\#' ${SAMPLE_TABLE} | grep -v '^;' | cut -f 2 | sort -u | xargs`
READ_NAMES=`grep -v '\#' ${SAMPLE_TABLE} | grep -v '^;' | cut -f 1 | sort -u | xargs`

TEST_READ_FILES=`grep -v '\#' ${SAMPLE_TABLE} | awk '$$3 == "test"' | grep -v '^;' | cut -f 2 | sort -u | xargs`
TEST_READ_NAMES=`grep -v '\#' ${SAMPLE_TABLE} | awk '$$3 == "test"' | grep -v '^;' | cut -f 1 | sort -u | xargs`


################################################################
## Output dir
DIR_RESULTS=analysis


################################################################
## Peaks
DIR_PEAKS=${DIR_RESULTS}/peaks

################################################################
## Extension of both sides of summits for fetching sequences
SUMMIT_EXT=1010


################################################################
## Random repetitions
RAND_REP_FROM=0
RAND_REP_NB=999
RAND_REPEATS=`perl -le 'for $$i (${RAND_REP_FROM}..${RAND_REP_NB}) {printf "%04d\n", $$i}' | xargs`

