\name{plot.mmiconf}
\alias{plot.mmiconf}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plot the observed degree distribution against resampled networks}
\description{This function displays resampled network sets which have been sampled, with replacement, from the edgelist (where all the nodes in the edgelist are sampled to find new edges).}
\usage{plot.mmiconf(net,replicates,mmiconf=NULL, ...)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ a edgelist for the network.}
  \item{replicates}{ a number of replicates which have been completed, found in \code{mmiconf}, or that should be sampled from \code{net}.}
  \item{mmiconf}{ output from running \code{mmi.conf} with \code{net} and \code{replicates}, in order to present the output from a fixed resamplling procedure.}}
\value{
	Returns a plot showing the observed degree distribution against that found for a number of resampled edge lists.}

\author{William P. Kelly and Michael P.H. Stumpf}
\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Fix the number of resampled networks required (this may be time consuming).
replicates <- 5

## Plot replicated resampled degree distributions against that found for the network.
plot.mmiconf(net,replicates)

## Find mmi.conf separately
mmiout <- mmi.conf(net,replicates)
plot.mmiconf(net,replicates,mmiout)
}
\keyword{utilities}
