\name{negloglike}
\alias{negloglike}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Negative log likelihood computation for degree sequence}
\description{
This function returns the negative log likelihood for a given degree sequence, using a supplied probability distribution (which need not be defined solely on the possible space). \code{dist} and \code{var} make up the defined model, which is normalised to be a probability density on the set of possible degrees (between 1 and the number of nodes - 1).
}
\usage{
negloglike(dseq,dist,var)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dseq}{ degree sequence as a vector where the \code{i}th entry \code{dseq[i]} is the number of nodes with degree \code{i} in the network.}
  \item{dist}{ defines a function which takes a degree \code{k} and parameters \code{var} to define the probability density.}
  \item{var}{ vector of parameters for the \code{dist} defined above.}
}
\value{
This function returns the negative log likelihood for \code{dseq} under the normalised, and discretised, model given by \code{dist(k,var)} where \code{k} is the degree of a node in the network.
}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Calculate its degree sequence ignoring redundant entries.
dseq <- degseq(net, redundant=TRUE)

## Now find the negative log likelihood for a powerlaw function with parameter values c(2,2.1,2.2,2.3).

for(i in c(2,2.1,2.2,2.3)){
	print(negloglike(dseq,dpowerlaw,i))
	}
}
