\name{distributions}
\alias{distributions}
\alias{dstretchedexp}
\alias{dlognormal}
\alias{dpowerlaw}
\alias{dexpnetz}
\alias{drandom}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Possible degree probability distributions}
\description{
A collection of functions which are used to define the probability for the degree of a network node. These can be any non-negative function defined on positive integers, which are later discretised for use in \code{\link{mmi.likelihoods}} and \code{\link{findmle}}.

The degree distribution models are discretised forms of the $P(d(v_i) = k; theta)$ shown here. In \code{netZ}, the \code{param} vector denotes the $theta$ shown here for poisson, exponential and power law models. For the log-normal and stretched exponential models, where 2 parameters are used to define the distribution, \code{param} $= (sigma, mu)$

Distribution & $P(d(v_i) = k; theta)$

Poisson & $frac{theta^k}{k!} exp(-theta)$ :  $k geq 0$
 
Exponential & $theta * exp(-theta * k)$ :  $k geq 0$

Power law  & $frac{k^{-theta}}{zeta(theta)}$ :  $k > 0$

Log-normal  & $frac{1}{sqrt{2 * pi} k * sigma}{exp(-frac{(log(k)- mu)^2}{2 * sigma^2})}$ : $k geq 0$ 

Stretched exponential & $frac{sigma}{mu} * (frac{k}{mu})^{sigma-1} * exp(-(frac{k}{mu})^{sigma})$ : $k > 0$ 
}
\usage{
dstretchedexp(k, param)

dlognormal(k, param)

dpowerlaw(k, param)

dexpnetz(k, param)

drandom(k, param)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{k}{ vector of quantiles (at which the function's value is sought).}
  \item{param}{ vector describing the parameters for the given distribution. \code{lognormal} and \code{stretchedexp} require a vector for 2 parameters whilst the others are defined by a single parameter.}
}
\value{
 The functions return the density for a collection of different distributions. 
 \code{dstretchedexp} gives the density for a stretched exponential; \code{dlognormal} for log normal; \code{dpowerlaw} for power-law; \code{dexpnetz} for exponential; and \code{drandom} for a Poisson distribution.
}
\author{ William P. Kelly and Michael P.H. Stumpf }

\examples{
## Test the value of a function for a particular degree, for functions with a single variable.
degrees <- c(1,5,10,20)
param <- 2

dpowerlaw(degrees, param)

dexpnetz(degrees, param)

drandom(degrees, param)

##The last two functions require 2 parameters to be defined.
param <- c(2,2)

dstretchedexp(degrees, param)

dlognormal(degrees, param)
}