\name{degseq}
\alias{degseq}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Degree Sequence of a Network}
\description{
This function returns the degree sequence of an edge list, along with the number of self-interactions and repeated interactions found in an edge list.
}
\usage{
degseq(net)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ edge list for the network data under consideration comprised of a list of prey and bait nodes or alternatively \code{cbind(prey, bait)}.}
}
\value{
A list with components:
  \item{degree}{ degree sequence is returned as a list (starting with the number of nodes of degree 1).}
  \item{indegree}{ degree sequence returned for the first vector of nodes in the edge list, for when edges have direction.}
  \item{outdegree}{ degree sequence returned for the second vector of nodes in the edge list, for when edges have direction.}

}
\author{William P. Kelly and Michael P.H. Stumpf}
\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Calculate its degree sequence ignoring redundant entries.
degseq(net)


}