plot.freqrank <- function(netdeg,freq=FALSE,rank=TRUE, ...){
	if(freq==TRUE){
		if(rank==TRUE){par(mfcol=c(1,2))}}
	thick<-0.4
	#par(mfcol=c(1,2))
	maxdeg<-length(netdeg)
	maxnodes<-sum(netdeg)

	if(freq==TRUE){
		plot(seq(1,length(netdeg))[netdeg > 0],netdeg[netdeg > 0],log="xy",yaxt="n",xaxt="n",ylab="Node Frequency", xlab="Node Degree",cex=thick,pch=16, ...)
		axis(1,format(10^(seq(from=0,to=log(maxdeg),by=1)),scientific=FALSE))
		axis(2,format(10^(seq(from=0,to=log(maxnodes),by=1)),scientific=FALSE))
	}
	if(rank==TRUE){
		ranks<-c()
		for(i in maxdeg:1){
			ranks <- c(ranks,rep(i,netdeg[i]))
			}
		plot(ranks,seq(1,length(ranks),by=1),log="xy",yaxt="n",xaxt="n",ylab="Node Rank", xlab="Node Degree",cex=thick,pch=16, ...)
		#print(length(ranks))
		#print(maxnodes)
		axis(2,format(10^(seq(from=0,to=log(maxnodes),by=1)),scientific=FALSE))
		axis(1,format(10^(seq(from=0,to=log(maxdeg),by=1)),scientific=FALSE))
		#axis(1,10^(seq(from=0,to=log(maxdeg),by=1)))
		#axis(2,10^(seq(from=0,to=log(maxnodes),by=1)))
	}
	par(mfcol=c(1,1))
}