\name{readnet}
\alias{readnet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Reading in network data}
\description{
This function reads in a network file, parses the data and returns a two column matrix.
}
\usage{
readnet(filename, simGraph = TRUE, sep = ",", header = FALSE, fill = TRUE, quote = "\"", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{filename}{ name of the data-file.}
  \item{simGraph}{ a logical value which determines if a simple graph version of the network should be considered (\emph{i.e.} a network without multiple edges and self-interactions). \code{simGraph} is set to \code{TRUE} by default.}
  \item{sep}{ character used to separate nodes of an edge.}
  \item{header}{  a logical value indicating whether the file contains the names of the variables as its first line.  If missing, the value is determined from the file format: \code{header} is set to \code{TRUE} if and only if the first row contains one fewer field than the number of columns.}
  \item{fill}{ logical. If \code{TRUE} then in case the rows have unequal length, blank fields are implicitly added.}
  \item{quote}{ the set of quoting characters. To disable quoting altogether, use 'quote = ""'.  See 'scan' for the behaviour on quotes embedded in quotes.}
 \item{\dots}{ relates to the further arguments found in \code{read.delim}.}
 }
\value{
The function returns a two column matrix containing the nodes incident on an edge in each row.
}
\author{Michael P.H. Stumpf}
\examples{
## Initialise a network dataset from a file, in this case the data from Pubmed ID article 10688190
data(pm10688190)

## Now rename the edge list as net.
net <- pm10688190
}
\seealso{\code{\link{read.delim}}}
