\name{plot.subdegreesequences}
\alias{plot.subdegreesequences}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plots the density functions for the MLE parameters for the standard models when the data are subsampled from the complete network.}
\description{This function plots 6 graphs showing the observed network data and the probability density functions for the tested models: Poisson (\code{\link{drandom}}), exponential (\code{\link{dexpnetz}}), power law (\code{\link{dpowerlaw}}), log normal (\code{\link{dlognormal}}), and stretched exponential (\code{\link{dstretchedexp}}). The network can either be given, or the output from \code{\link{mmi.likelihoods}}, \code{\link{mmi.akaike}}, and \code{\link{degseq}} for a given \code{net}.}
\usage{plot.subdegreesequences(net=NULL,netdeg=NULL,netlike=NULL,netakaike=NULL,nodes=1,plotdegree=100,thick=2,ylimit=c(0,1), ...)}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ a network edgeless. If given, the previous entries can be left as \code{NULL}.}
  \item{netlike}{ the likelihood output for a given \code{net} dataset.}
  \item{netakaike}{ the output for a given \code{net} from \code{\link{mmi.akaike}}.}
  \item{netdeg}{ the output for a given \code{net} from \code{\link{degseq}}.}
  \item{nodes}{ The number of nodes, with at least one connection, found in the complete network.}
  \item{plotdegree}{ The degree up to which the plots should plot.}
  \item{thick}{ a value detailing the thickness of the bars shown in the plots.}
  \item{ylimit}{ a vector presenting the \code{limit} for the plots.}
}
\value{ Returns a set of plots, with the degree distribution densities (best fit for the \code{net} using the MLEs from \code{\link{mmi.likelihoods}}) and the Akaike weighted output. The observed data are overlaid on the plots using black 'x'.}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Plot the best fit degree distributions
plot.subdegreesequences(net=net,nodes=100,plotdegree=50,ylimit=c(0,0.5),thick=0.8)
}

\seealso{ \code{\link{plot}}}
\keyword{utilities}
