\name{mmi.likelihoods}
\alias{mmi.likelihoods}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Find the MLE for standard distributions}
\description{
This function takes a net (as an edge list), or a degree list (as a vector where entry \code{i} details the number of nodes with degree \code{i}), and returns the number of samples and maximum likelihood estimates for standard probability distributions (as detailed in \code{\link{distributions}}). }
\usage{
mmi.likelihoods(net,parrand=c(0.1,100),parexp=c(0.01,1),parpow=c(1.01,10),parlnorm=c(1,1),parstrexp=c(1,1),nodes=1,degree=FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{net}{ an edge list for a network, or if \code{degree = TRUE} a degree list.}
  \item{parrand}{ vector describing the \code{min} and \code{max} for the \code{drandom} distribution parameter, over which the likelihood is assessed.}
  \item{parexp}{ vector describing the \code{min} and \code{max} for the \code{dexpnetz} distribution parameter.}
  \item{parpow}{ vector describing the \code{min} and \code{max} for the \code{dpowerlaw} distribution parameter.}
  \item{parlnorm}{ vector describing the starting parameter values for the \code{dlognormal} distribution parameter, from where the optimisation is seeded.}
  \item{parstrexp}{ vector describing the starting parameter values for the \code{dstretchedexp} distribution parameter, from where the optimisation is seeded.}
  \item{nodes}{ the complete number of nodes found in the network, if data is viewed as a subsample of the complete network, using \code{\link{subsample}}. This is only necessary if the parameter values, as opposed to the maximum likelihoods, are sought for each function.}
  \item{degree}{ detailing whether \code{net} is a degree sequence.}
}
\value{
A list with components:
  \item{sampled}{ the number of samples found in the network data.}
  \item{poisson}{ list containing the output for \code{\link{drandom}} from \code{\link{findmle}}. The list has entries \code{param} and \code{lik}.}
  \item{exponential}{ list containing the output for \code{\link{dexpnetz}} from \code{\link{findmle}}. The list has entries \code{param} and \code{lik}.}
  \item{powerlaw}{ list containing the output for \code{\link{dpowerlaw}} from \code{\link{findmle}}. The list has entries \code{param} and \code{lik}.}
  \item{lognormal}{ list containing the output for \code{\link{dlognormal}} from \code{\link{findmle}}. The list has entries \code{param} and \code{lik}.}
  \item{stretchedexp}{ list containing the output for \code{\link{dstretchedexp}} from \code{\link{findmle}}. The list has entries \code{param} and \code{lik}.}
}
\author{William P. Kelly and Michael P.H. Stumpf}
\examples{
## Generate a random network with 50 nodes and 400 edges
nodes <- 50
edges <- 400
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Find the maximum likelihoods for the five given distributions.
likelihoods <- mmi.likelihoods(net)

## Compare the parameter estimates with those for a sample from a complete network with 100 nodes
sublikelihoods <- mmi.likelihoods(net,nodes=100)

## Print out the likelihoods found for the complete and sub networks, using the same degree sequence data.
likelihoods$random
sublikelihoods$random
}
\seealso{\code{\link{mmi.akaike}}, \code{\link{mmi.conf}}}