\name{findmle}
\alias{findmle}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Find the Maximum Likelihood Parameters for Network and Degree Distribution}
\description{
This function returns the parameter (and likelihood) values which maximise the likelihood for a particular network dataset and corresponding degree distribution.
}
\usage{
findmle(dseq, dist, min=0, max=0)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dseq}{ degree sequence for a network. A vector where entry i gives the number of nodes with degree i in the network (so there is no entry for those items with degree 0).}
  \item{dist}{ degree distribution for the nodes in the network. This is a function which requires two arguments, a vector of degrees (k) and a vector of the relevant parameters (param). Ready functions, used in \code{\link{mmi.likelihoods}}, can be found in \code{\link{distributions}}.}
  \item{min}{ a vector describing the parameter values used for the likelihood optimisation. For single parameter functions, this is the minimum value used in \code{\link{optim}}, whilst it is the first point assessed for functions with multiple parameters (as used in \code{\link{optimise}}).}
  \item{max}{ a value giving the maximum value assessed for single parameter optimisation. This is not necessary for \code{dist} functions that require more than one parameter to be defined.}
}
\value{
A list with components:
  \item{param}{ vector of parameter values which maximise the likelihood of \code{dist}.}
  \item{lik}{ value of likelihood for the parameter values given in \code{var}.}
}
\author{William P. Kelly and Michael P.H. Stumpf}

\examples{
## Generate a random network with 50 nodes and 300 edges
nodes <- 50
edges <- 300
net<-matrix(ceiling(nodes*runif(2*edges)),ncol=2)

## Calculate its degree sequence and return the number of repeats, and self-interactions, have in the list.
dseq <- degseq(net, redundant=TRUE)$degree

## Find the maximum likelihood for the log normal function.
dist <- dlognormal
maxlike <- findmle(dseq,dist,min=c(2,2))

## The maximum likelihood for dseq and dist.
maxlike$lik

## The parameter values where the likelihood is maximal.
maxlike$var
}