#Initialise the package, which should have already been completed.
#library(netZ)

## Load the Y2H dataset from Ito et al (2001)
data(pm11283351)

## Example Y2H dataset
Y2H <- pm11283351

## Find the degree sequence, and other sampling information for the dataset
Y2Hdeg <- degseq(Y2H)

## The number of different nodes found in the dataset can be found:
sum(Y2Hdeg$degree)

## Find the likelihoods for the standard degree distribution models: power law, random (Poisson), exponential, log normal, and stretched exponential.
Y2Hlike <- mmi.likelihoods(Y2H)

## In reality, the network is superset of this sampled data, so we would like to fit the distribution models to a network which has been sampled from the proteome with more nodes.

## This operation will take time,given the size of the original set (766 nodes). Reducing the number of nodes will speed up the calculation if only required for example (as completed here with nodes=1000 rather than the true proteome size).
## nodes <- 5800
## This may take several hours, so has been precomputed in the data directory.
## Y2Hsublike <- mmi.likelihoods(Y2H, nodes=nodes)

## For PIN size estimates, the model assumes all proteins have at least 1 interaction. So, in reality, the nodes should reflect the number of proteins that interact, rather than the total number of proteins in the proteome (if orphan proteins exist they should be ignored).

data(Y2Hsublike1000)
data(Y2Hsublike5800)

## Find the akaike weights from the likelihood data:
Y2Hsublike1000akaike <- mmi.akaike(Y2Hsublike1000,mmi=TRUE)
Y2Hsublike5800akaike <- mmi.akaike(Y2Hsublike5800,mmi=TRUE)

## To estimate the size of the interactome from these estimates, we use the maximum likelihood parameter estimates taken from Y2Hsublike5800.
mmi.interactomesize(Y2Hsublike1000,mmi=TRUE)
mmi.interactomesize(Y2Hsublike5800,mmi=TRUE)

## This returns an estimate for the size for each distribution, as well as the weighted Akaike degree distribution, which can also be shown for the full set (along with the observed data overlaid) in the following:
plot.subdegreesequences(netdeg=Y2Hdeg, netlike=Y2Hsublike1000,netakaike=Y2Hsublike1000akaike,nodes=1000,plotdegree=50,ylimit=c(0,0.8),thick=0.8)

## Now plot for the 5800 node proteome, rather than 1000.
plot.subdegreesequences(netdeg=Y2Hdeg, netlike=Y2Hsublike5800,netakaike=Y2Hsublike5800akaike,nodes=5800,plotdegree=50,ylimit=c(0,0.6),thick=0.8)
 
