## Load the C. jejuni interaction data from Parrish et al (2007)
data(cjejuni)

## Example Y2H dataset
Y2H <- cjejuni

## Print out first 5 items of edge list to see format for all network sets
Y2H[1:5,]

## Find the degree sequence, and other sampling information for the dataset
Y2Hdeg <- degseq(Y2H)

## The degree sequence include information on the number of edges, and direction if the vectors are input for a directed network:
Y2Hdeg

## The number of different nodes found in the dataset can be found:
sum(Y2Hdeg$degree)


## Plot the degree distribution, in this using both frequency-degree and rank-degree plots on log-log scale, using the degree sequence entry from Y2Hdeg.
plot.freqrank(Y2Hdeg$degree,freq=TRUE)

## See Figure to see the expected output. It can be seen that the data have a large number of nodes with low degree, 
## and a smaller collection of proteins with a large number of neighbours, which may suggest a fat tailed distribution. 
## However, in order to test this, likelihood analysis is performed, rather than just using this diagnostic plot.

## Find the likelihoods for the standard degree distribution models: power law, random (Poisson), exponential, log normal, and stretched exponential.
Y2Hlike <- mmi.likelihoods(Y2H)

## Now that MLE has been used to fit the standard models, the same rank and frequency plots can be overlaid with the best fit lines from the different models.
par(mfcol=c(1,2))
plot.modelfreq(Y2H, Y2Hlike,title="")
plot.modelrank(Y2H, Y2Hlike,title="")
par(mfcol=c(1,1))

## See Figure to see the new output. Now it can be seen how each model performs, and the large differences, 
## by eye, in how the models fit dependent on how the data are plotted. In reality, rank-degree plots should be used 
## when attempting to assess power law behaviour (as explained in Doyle et al (2005)), rather than frequency-degree plots. 
## The rank-degree plot shows that the power law fit overstates the number of nodes with relatively high degrees, 
## whilst the other tested models predict fewer hubs.

## Now we will use the likelihoods and parameter values to find the Akaike weights, to determine 
## the model selected to represent the data, presented in the following collection of plots.
plot.modelsummary(Y2Hlike)

## The first Figure shows the degree sequence for the dataset Y2H. The barplot in blue shows the likelihoods found from MLE for each of the models. 
## The final two graphs show the different weights, with the left hand plot showing the relative differences between the smallest 
## (as the plot is show on a log scale) weight values (those models which do not best model the data), whilst the right hand plot 
## (which is not on a log scale) shows how the majority of the Akaike weight is placed on the Log Normal model, 
## which would be chosen out of these 5 to best represent the data.

## Alternatively, the Akaike weights can be returned using the following function. 
## The below two commands are identical, although the second will take longer to calculate.
Y2Hakaike <- mmi.akaike(Y2Hlike,mmi=TRUE)
# Y2Hakaike <- mmi.akaike(Y2H,mmi=FALSE)

## Finally, in order to better appreciate how the models used represent the degree sequences, 
## these show the probability density functions (which as throughout have been discretised and truncated 
## to reflect the number of nodes in the data) and how they match against the observed data (shown in 'x'). 
## Alongside the  tested models, the Akaike weighted pdf is also shown (which is a combination of all the tested models
## according to the weights found in Y2Hakaike).
plot.degreesequences(Y2Hlike,Y2Hakaike,Y2Hdeg)
