plot.subdegreesequences <- function(net=NULL,netdeg=NULL,netlike=NULL,netakaike=NULL,nodes=1,plotdegree=100,thick=2,ylimit=c(0,1), ...){
	if(!is.null(net)){
		netdeg <- degseq(net)
		subnodes <- sum(netdeg$degree)
		netlike <- mmi.likelihoods(net,nodes=nodes)
		netakaike <- mmi.akaike(netlike,mmi=TRUE)
		}
	#maxpdeg <- sum(netdeg$degree) - 1
	maxdeg<-length(netdeg$degree)
	#nodes <- sum(netdeg$degree)
	maxpdeg <- nodes - 1
	#if(output == "All"){par(mfcol=c(2,3))}
	
	par(mfcol=c(2,3))
	plot(seq(1:plotdegree),netakaike$akaikeprob[1:plotdegree],xlab="Node Degree",ylab="Probability",type = "h", col = "blue",lwd=thick,main="Akaike Weighted",ylim=ylimit)
	points(netdeg$degree/nodes,pch='x', ...)

	"plotdeg" <- function(val,norm,density,name,ylimit){
		plot(seq(1:plotdegree),density[1:plotdegree],xlab="Node Degree",ylab="Probability",type = "h", col = "blue",lwd=thick,main=name, ylim=ylimit,cex.main=1.25,cex.lab=1.25, ...)
	}

	val <- netlike$poisson$param
	norm <- sum(drandom(seq(1:maxpdeg),val))
	density <- drandom(seq(1:maxpdeg),val)/norm
	name <- "Poisson"
	plotdeg(val,norm,density,name,ylimit)
	points(netdeg$degree/nodes,pch='x')

	val <- netlike$exponential$param
	norm <- sum(dexpnetz(seq(1:maxpdeg),val))
	density <- dexpnetz(seq(1:maxpdeg),val)/norm
	name <- "Exponential"
	plotdeg(val,norm,density,name,ylimit)
	points(netdeg$degree/nodes,pch='x')

	val <- netlike$powerlaw$param; norm <- sum(dpowerlaw(seq(1:maxpdeg),val)); density <- dpowerlaw(seq(1:maxpdeg),val)/norm; name <- "Power Law"
	plotdeg(val,norm,density,name,ylimit)
	points(netdeg$degree/nodes,pch='x')

	val <- netlike$lognormal$param; norm <- sum(dlognormal(seq(1:maxpdeg),val)); density <- dlognormal(seq(1:maxpdeg),val)/norm; name <- "Log Normal"
	plotdeg(val,norm,density,name,ylimit)
	points(netdeg$degree/nodes,pch='x')

	val <- netlike$stretchedexp$param; norm <- sum(dstretchedexp(seq(1:maxpdeg),val)); density <- dstretchedexp(seq(1:maxpdeg),val)/norm; name <- "Stretched Exponential"
	plotdeg(val,norm,density,name,ylimit)
	points(netdeg$degree/nodes,pch='x')
	#if(output=="All"){par(mfcol=c(1,1))}
	par(mfcol=c(1,1))
}