plot.modelsummary <- function(net,degree=FALSE,likelihood=TRUE,IC="AIC", ...){
	if(degree==TRUE){
		dseq <- net
		netlike<- mmi.likelihoods(dseq,degree=TRUE)
		}else{	
			if(likelihood==FALSE){
				dseq <- degseq(net)$degree
				netlike <- mmi.likelihoods(net)
			}else{
				dseq <- net$dseq
				netlike <- net	
			}
		}

	nodes <- netlike$sampled$nodes
	netakaike <- mmi.akaike(netlike,mmi=TRUE,IC=IC)
	models <- c("Poisson", "Exponential", "Power Law", "Log Normal", "Stretched\nExponential")
	par(mfcol=c(2,2))
	maxdeg<-length(dseq)
	plot(seq(1:maxdeg),dseq/nodes,pch='x',xlab="Node Degree",ylab="Proportion of Network",ylim=c(0,1),cex.main=1.25,cex.lab=1.25, ...)
	weights <- c(netakaike$poisson,netakaike$exponential,netakaike$powerlaw,netakaike$lognormal,netakaike$stretchedexp)
	maxweight <- max(weights)
	minweight <- min(weights)
	ylimit <- c(minweight,maxweight)
	logweights <- weights
	if(minweight==0){logylimit <- c(-10000,log(maxweight))
		}else{logylimit <- log(ylimit)}
	logweights[weights > 0] <- log(weights[weights > 0])
	logweights[weights == 0] <- -10500	

	barplot(logweights, names=models,cex.names=0.75, las=3, border=FALSE, ylab="log(Akaike Weight)", col='red', ylim=logylimit,cex.main=1.25,cex.lab=1.25)
	likelihoods <- c(netlike$poisson$lik,netlike$exponential$lik,netlike$powerlaw$lik,netlike$lognormal$lik,netlike$stretchedexp$lik)
	barplot(likelihoods, names=models,cex.names=0.75, las=3, border=FALSE, ylab="log(Likelihood)", col='blue',cex.main=1.25,cex.lab=1.25)
	barplot(weights, names=models,cex.names=0.75, las=3, border=FALSE, ylab="Akaike Weight", col='red',cex.main=1.25,cex.lab=1.25)
	#barplot(logweights, names=models,cex.names=0.45, border=FALSE, xlab="Degree Distribution Model", ylab="log(Akaike Weight)", col='red', ylim=logylimit,cex.main=1.5,cex.lab=1.5)
	#likelihoods <- c(netlike$random$lik,netlike$exponential$lik,netlike$powerlaw$lik,netlike$lognormal$lik,netlike$stretchedexp$lik)
	#barplot(likelihoods, names=models,cex.names=0.45, border=FALSE, xlab="Degree Distribution Model", ylab="log(Likelihood)", col='blue',cex.main=1.5,cex.lab=1.5)
	#barplot(weights, names=models,cex.names=0.45, border=FALSE, xlab="Degree Distribution Model", ylab="Akaike Weight", col='red',cex.main=1.5,cex.lab=1.5)
	par(mfcol=c(1,1))
}