plot.modelrank <- function(net,netlike=NULL,nodethick=0.4,title="Expected Rank-Degree Plots for MLE Models",textsize=0.6,upper=TRUE, ...){
	netdeg <- degseq(net)
	if(is.null(netlike)){netlike<-mmi.likelihoods(net)}
	#if(is.null(netakaike)){netakaike<-mmi.akaike(netlike,mmi=TRUE)}
	
	maxpdeg <- sum(netdeg$degree)-1; maxdeg <- length(netdeg$degree) 
	nodes <- maxpdeg + 1
	ranks<-c()
	thick <- nodethick
	for(i in maxdeg:1){
		ranks <- c(ranks,rep(i,netdeg$degree[i]))
		}
	if(maxpdeg > 1000){
		maxplot <- maxpdeg/5
		}else{maxplot <- maxpdeg}
	plot(ranks,seq(1,nodes,by=1),log="xy",yaxt="n",xaxt="n",ylab="Node Rank", xlab="Node Degree",main=title,cex=thick,pch=16,xlim =c(1,maxpdeg), ...)
	axis(2,format(10^(seq(from=0,to=log(maxpdeg/10),by=1)),scientific=FALSE))
	axis(1,format(10^(seq(from=0,to=log(maxplot),by=1)),scientific=FALSE))
	edges <- netdeg$samples - netdeg$self - netdeg$repeats
	
	#aktest <- netakaike$akaikeprob
	#akaranks <- c()
	#remain <- 0
	#aktest[maxdeg] <- sum(aktest[maxdeg:length(aktest)])
	#for(i in maxdeg:1){
	#	test <- aktest[i]*maxnodes + remain
	#	akaranks <- c(akaranks,rep(i,floor(test)))
	#	remain <- test - floor(test)
	#	}
	#lines(akaranks,seq(1,nodes,by=1),col='red',pch='x')
	if(upper==TRUE){
	drawrankline <- function(density,color,maxnodes,densum=1){
		rankdensity <- c()
		if(densum==1){remain <- 0
			}else{remain <- (1 - sum(density))*maxnodes}
		maxpdeg <- maxnodes - 1
		for(i in maxpdeg:1){
			test <- density[i]*maxnodes + remain
			rankdensity <- c(rankdensity,rep(i,floor(test)))
			remain <- test - floor(test)
			}
		return(lines(rankdensity,seq(1,length(rankdensity),by=1),col=color))
		}
	}else{
	drawrankline <- function(density,color,maxnodes,densum=1){
		rankdensity <- c()
		if(densum==1){remain <- 0
			}else{remain <- (1 - sum(density))*maxnodes}
		maxpdeg <- maxnodes - 1
		for(i in 1:maxpdeg){
			test <- density[i]*maxnodes + remain
			rankdensity <- c(rankdensity,rep(i,floor(test)))
			remain <- test - floor(test)
			}
		return(lines(rankdensity[length(rankdensity):1],seq(1,length(rankdensity),by=1),col=color))
		}}

	val <- netlike$poisson$param
	norm <- sum(drandom(seq(1:maxpdeg),val))
	density <- drandom(seq(1:maxpdeg),val)/norm
	name <- "Poisson"
	drawrankline(density,"green",nodes)

	val <- netlike$exponential$param
	norm <- sum(dexpnetz(seq(1:maxpdeg),val))
	density <- dexpnetz(seq(1:maxpdeg),val)/norm
	name <- "Exponential"
	drawrankline(density,"blue",nodes)

	val <- netlike$powerlaw$param; norm <- sum(dpowerlaw(seq(1:maxpdeg),val)); density <- dpowerlaw(seq(1:maxpdeg),val)/norm; name <- "Power Law"
	drawrankline(density,"red",nodes)
	
	val <- netlike$lognormal$param; norm <- sum(dlognormal(seq(1:maxpdeg),val)); density <- dlognormal(seq(1:maxpdeg),val)/norm; name <- "Log Normal"
	drawrankline(density,"purple",nodes)

	val <- netlike$stretchedexp$param; norm <- sum(dstretchedexp(seq(1:maxpdeg),val)); density <- dstretchedexp(seq(1:maxpdeg),val)/norm; name <- "Stretched Exponential"
	drawrankline(density,"cyan",nodes)

    models <- c("Poisson", "Exponential", "Power Law", "Log Normal", "Stretched Exponential","Observed Network")
    colors <- c("green","blue","red","purple","cyan","black")
    legend("topright", legend=models, col=colors, pch=c(rep(15,5),16),cex=textsize, inset = .02)
	}