mmi.likelihoods <-
function(net,parrand=c(0.1,100),parexp=c(0.05,1),parpow=c(1.01,20),parlnorm=c(20,20),parstrexp=c(0.5,10),nodes=1,degree=FALSE){
  if(degree==TRUE){
	deg <- net
	}else{netstat <- degseq(net)  
		deg <- netstat$degree}
  if(nodes > sum(deg)){
 		S <- sum(deg); N <- nodes
		dsub <- function(k,var){
			#subsample(k,S=S,N=N,dist=dtest,var)
			dist <- dtest
			prob <- 0
			l <- seq(1:N)
			for(i in k:N){
				prob <- prob + dbinom(k,i,S/N)*dist(i,var)
				}
			return(prob)	
			}
 		print(paste(date(),"Subsampling",S,'from',N,'nodes.',sep=' '))
 		#print(c(S, N))
 		}else{
 			S <- sum(deg); N <- sum(deg)
 			dsub <- function(k,var){dtest(k,var)}
 			}

  if(nodes > sum(deg)){print(paste(date(),"Poisson Likelihood",sep=' '))}
  dtest<-drandom
  poisson<- findmle(deg,dsub,min=parrand[1],max=parrand[2])
  if(nodes > sum(deg)){print(paste(date(),"Exponential Likelihood",sep=' '))}
  dtest<-dexpnetz
  exponential<- findmle(deg,dsub,min=parexp[1],max=parexp[2])
  if(nodes > sum(deg)){print(paste(date(),"Powerlaw Likelihood",sep=' '))}
  dtest<-dpowerlaw
  powerlaw<-findmle(deg,dsub,min=parpow[1],max=parpow[2])
  if(nodes > sum(deg)){print(paste(date(),"Log normal Likelihood",sep=' '))}
  dtest<-dlognormal
  lognormal<-findmle(deg,dsub,min=parlnorm,max=0)
  if(nodes > sum(deg)){print(paste(date(),"Stretched Exponential Likelihood",sep=' '))}
  dtest<-dstretchedexp
  strexp<- findmle(deg,dsub,min=parstrexp,max=0)
  subs <- list(nodesampled=S,nodes=N)
  if(nodes > sum(deg)){print(paste(date(),"Finished",sep=' '))}
  
  return(list(dseq=deg,sampled=subs,poisson=poisson,exponential=exponential,powerlaw=powerlaw,lognormal=lognormal,stretchedexp=strexp))
  }