################################################################
## Compare results of predictions, ChIP-chip data and expression data

##  source('~/research/discriminant_analysis/met_pho/R-files/comparisons_chip_expression_predictions.R')

setwd('~/research/R-files')
source('~/research/R-files/config.R')
source(file.path(dir.util, 'util.R'))

dir.main <- file.path(dir.home, 'research','discriminant_analysis','met_pho')
setwd(file.path(dir.main, "R-files"))
dir.data <- file.path(dir.main, 'data')


################################################################
## Load Chip-CHIP data from Lee et al (2002)
verbose ("Loading Lee", 1)
source('load_young.R')

## Select phosphate and methionine-related experiments
chip2.pho4 <- chip2[,"PHO4"]
chip2.cbf1 <- chip2[,"CBF1"]
chip2.met4 <- chip2[,"MET4"]
chip2.met31 <- chip2[,"MET31"]

chip2.selected <- data.frame("MET31"=chip2.met31, "CBF1"=chip2.cbf1, "MET4"=chip2.met4, "PHO4"=chip2.pho4, row.names=row.names(chip2))

chip2.selected.sig <- -log(chip2.selected*nrow(chip2.selected), base=10)

## Plot Chip-CHIP for selected experiments
# plot(chip2.selected.sig)

################################################################
## Load ChIP-CHIP data from Harbison et al (2004)
dir.data <- file.path(dir.main, 'data')

verbose ("Loading Harbison", 1)
file.harbison.ypd.metpho <- file.path(dir.data,'chip_chip', 'harbison_YPD_Pval_MET_PHO_selection.tab')
harbison.ypd.metpho <- read.table(file.harbison.ypd.metpho,sep='\t',as.is=T,row.names=1, quote='"',header=1)

file.harbison.other.metpho <- file.path(dir.data,'chip_chip', 'harbison_other_Pval_MET_PHO_selection.tab')
harbison.other.metpho <- read.table(file.harbison.other.metpho,sep='\t',as.is=T,row.names=1, quote='"',header=1)

## merge the two datasets from Harbison
(errors <- c(setdiff(row.names(harbison.ypd.metpho),row.names(harbison.other.metpho)),
            setdiff(row.names(harbison.other.metpho),row.names(harbison.ypd.metpho))))

if (length(errors) > 0) {
  stop("Cannot merge the two datasets from Harbison because gene names difffer")
}

harbison.Pval <- cbind(harbison.ypd.metpho[,3:ncol(harbison.ypd.metpho)], harbison.other.metpho[,3:ncol(harbison.other.metpho)])
print (paste("Genes in Harbison data", nrow(harbison.Pval)))
harbison.sig <- -log(harbison.Pval*nrow(harbison.Pval), base=10)
names(harbison.Pval) <- paste('harbison', 'Pval', names(harbison.Pval), sep=".")
names(harbison.sig) <- paste('harbison', 'sig', names(harbison.sig), sep=".")

################################################################
## Load expression data from Ogawa et al. 
verbose("Loading expression", 1)
setwd(file.path(dir.main, "R-files"))
data.type <- "expression"
source("load_met_pho_data.R")
expression <- data

source(file.path(dir.util, 'util_chip_standardization.R'))
expression.standardized <- standardize.chips(expression)
hist (expression.standardized$z[,"PHO4c_vs_WT"],breaks=100)
hist (expression.standardized$E.value[,"PHO4c_vs_WT"],breaks=100)
z.thresh <- -qnorm(1/n, mean=0, sd=1, lower.tail = TRUE, log.p = FALSE)

################################################################
## Load matrix scores
verbose("Loading Matrix score", 1)
setwd(file.path(dir.main,'R-files'))
data.type <- "matrix_scores"
source("load_met_pho_data.R")
matrix.scores <- data

################################################################
## Load LDA results with matrix scores
verbose("Loading Matrix score predictions", 1)
predictions.MET.file <- file.path(dir.main, 'results','discrim_results','matrix_scores_MET', 'matrix_scores_MET_noPC_stepwise_LDA_pred.tab')
predictions.MET <- read.table(predictions.MET.file,sep='\t',header=T,row.names=1)

predictions.PHO.file <- file.path(dir.main, 'results','discrim_results','matrix_scores_PHO', 'matrix_scores_PHO_noPC_stepwise_LDA_pred.tab')
predictions.PHO <- read.table(predictions.PHO.file,sep='\t',header=T,row.names=1)

################################################################
## Load LDA results with expression data
verbose("Loading expression predictions", 1)
predictions.expression.file <- file.path(dir.main,'results','discrim_results','expression_PHO','expression_PHO_stepwise_PDA_all_pred.tab')
predictions.expression <- read.table(predictions.expression.file,sep='\t',header=T,row.names=1)

################################################################
## Compare chip2 results and matrix scores
verbose("Comparing genes for the different data sets", 1)
dir.create.check(dir.figures)

## Calculate intersections between data sets
ORFs.chip2 <- row.names(chip2)
ORFs.matrix.scores <- row.names(matrix.scores)
ORFs.expression <- row.names(expression)

ORFs.chip2.and.expression <- intersect(ORFs.chip2, ORFs.expression)
verbose(paste("Chip2 + expression : ", length(ORFs.chip2.and.expression), "ORFs"),1)

ORFs.chip2.and.matrix.scores <- intersect(ORFs.chip2, ORFs.matrix.scores)
verbose(paste("Chip2 + matrix.scores : ",length(ORFs.chip2.and.matrix.scores), "ORFs"),1)

ORFs.matrix.scores.and.expression <- intersect(ORFs.matrix.scores, ORFs.expression)
verbose(paste("Matrix.Scores + expression : ", length(ORFs.matrix.scores.and.expression), "ORFs"),1)

ORFs.intersect <- intersect(ORFs.matrix.scores.and.expression,ORFs.chip2)
verbose(paste( "Matrix.Scores + expression + Chip2 : ", length(ORFs.intersect), "ORFs"),1)

## Calculate sig index from posterior probabilities
## Note: I am not sure these P-values are really indicative
predictions.MET$sig.MET <- -log(nrow(predictions.MET)*(1 - predictions.MET$posterior.MET),base=10)
predictions.PHO$sig.PHO <- -log(nrow(predictions.PHO)*(1 - predictions.PHO$posterior.PHO),base=10)
predictions.expression$sig.PHO <- -log(nrow(predictions.expression)*(1 - predictions.expression$posterior.PHO),base=10)

################################################################
## A big table with all the data + results for all the genes
## THIS IS REAL SYSTEMS BIOLOGY !
verbose("Merging the data", 1)
comparison <- cbind(gene=predictions.PHO[ORFs.matrix.scores.and.expression,"NAME"],
		    ogawa=expression[ORFs.matrix.scores.and.expression,],
		    ogawa.extr=expression.standardized$extr[ORFs.matrix.scores.and.expression,],
		    chip2.Pval=chip2.selected[ORFs.matrix.scores.and.expression,],
		    chip2.sig=chip2.selected.sig[ORFs.matrix.scores.and.expression,],
		    matrix.scores=matrix.scores[ORFs.matrix.scores.and.expression,],
		    lda.expression.posterior.PHO=predictions.expression[ORFs.matrix.scores.and.expression,"posterior.PHO"],
		    lda.matrix.scores.posterior.PHO=predictions.PHO[ORFs.matrix.scores.and.expression,"posterior.PHO"],
		    lda.matrix.scores.posterior.MET=predictions.MET[ORFs.matrix.scores.and.expression,"posterior.MET"],
		    lda.expression.sig.PHO=predictions.expression[ORFs.matrix.scores.and.expression,"sig.PHO"],
		    lda.matrix.scores.sig.PHO=predictions.PHO[ORFs.matrix.scores.and.expression,"sig.PHO"],
		    lda.matrix.scores.sig.MET=predictions.MET[ORFs.matrix.scores.and.expression,"sig.MET"],
		    group.labels=group.labels[ORFs.matrix.scores.and.expression]
		    )

## Incorporate expression data from Ogwawa in the comparison
## mean per gene
comparison$ogawa.z.mean <- apply(expression.standardized$z[ORFs.matrix.scores.and.expression,],1,mean)
## two first components after PCA transform
expression.pc <- prcomp(expression.standardized$z)
comparison$ogawa.PC1 <- expression.pc$x[ORFs.matrix.scores.and.expression,1]
comparison$ogawa.PC2 <- expression.pc$x[ORFs.matrix.scores.and.expression,2]

## Incorporate selected columns from Harbison
comparison$harbison.ypd.metpho <- harbison.ypd.metpho[row.names(comparison), ]
comparison$harbison.other.metpho <- harbison.other.metpho[row.names(comparison), ]

### Sort the comparison table by training class
comparison <- comparison[rev(order(comparison$group.labels,decreasing=T)),]
## Export the comparison table
setwd(dir.results); export.object(comparison, file='comparison_expr_chip2_matrices',export.formats='table')

## ##############################################################
## Define plot parameters
bw <- T

if (bw) {
  bw.palette <- c('#222222', '#111111', '#000000')
  group.colors <- get.colors(comparison,comparison$group.labels,custom.palette=bw.palette)
  abline.color <- "#000000"
  comparison.palette <- c(CTL='#222222',
                          MET='#111111',
                          PHO='#000000')
} else {
  comparison.palette <- get.palette(comparison,comparison$group.labels)
  group.colors <- get.colors(comparison,comparison$group.labels,custom.palette=bw.palette)
  abline.color <- "#880000"
}
group.pch <- as.vector(comparison$group.labels)
group.pch[is.na(group.pch)] <- "+"
group.pch[group.pch=="PHO"] <- "P"
group.pch[group.pch=="MET"] <- "M"
group.pch[group.pch=="CTL"] <- "C"

################################################################
## Some comparative plots
export.formats.plots <- c("ps","pdf")

verbosity <- 2


################################################################
## Predictions versus ChIP-chip experiments

# ## MET predictions vs chips (a 4x4 plot)
# plot(comparison[,c("chip2.sig.MET4","chip2.sig.MET31","chip2.sig.CBF1","lda.matrix.scores.posterior.MET")],
#      col=group.colors,
#      pch=group.pch)
# setwd(dir.figures); export.plot(file.prefix='MET_pred_post__vs__Lee_sig', export.formats=export.formats.plots, width=15,height=15)

X11(width=8,height=8)
par(mai=c(1,1.2,0.2,0.2))
par(font=2)
par(font.lab=2)

par(cex=1)
par(cex.lab=1)
par(cex.axis=1)

## MET4 ChIP-chipvs MET31 ChIP-chip
plot(comparison[,c("chip2.sig.MET4","chip2.sig.MET31")],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0,col=comparison.palette["MET"],lwd=2),
       abline(v=0,col=comparison.palette["MET"],lwd=2)
       ),
     xlab="ChIP-chip binding values for MET4 (sig=-log10(N*P-value))",
     ylab="ChIP-chip binding values for MET31 (sig=-log10(N*P-value))"
     )
setwd(dir.figures); export.plot(file.prefix='MET4_Lee_sig__vs__MET31_Lee_sig', export.formats=export.formats.plots, width=8,height=8)

################################################################
## MET predictions versus each MET ChIP-chip separately

## MET predictions versus MET4 ChIP-chip
plot(comparison[,c("chip2.sig.MET4","lda.matrix.scores.posterior.MET")],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=comparison.palette["MET"],lwd=2),
       abline(v=0,col=comparison.palette["MET"],lwd=2)
       ),
     xlab="ChIP-chip binding values for MET4 (sig=-log10(N*P-value))",
     ylab="MET prediction (post. proba.)"
     )
setwd(dir.figures); export.plot(file.prefix='MET_pred_post__vs__MET4_Lee_sig', export.formats=export.formats.plots, width=8,height=8)

## MET predictions vs MET31 ChIP-chip
plot(comparison[,c("chip2.sig.MET31","lda.matrix.scores.posterior.MET")],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=comparison.palette["MET"],lwd=2),
       abline(v=0,col=comparison.palette["MET"],lwd=2)
       ),
     xlab="ChIP-chip binding values for MET31 (sig=-log10(N*P-value))",
     ylab="MET prediction (post. proba.)"
     )
setwd(dir.figures); export.plot(file.prefix='MET_pred_post__vs__MET31_Lee_sig', export.formats=export.formats.plots, width=8,height=8)

## MET predictions versus CBF1 ChIP-chip
plot(comparison[,c("chip2.sig.CBF1","lda.matrix.scores.posterior.MET")],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=comparison.palette["MET"],lwd=2),
       abline(v=0,col=comparison.palette["MET"],lwd=2)
       ),
     xlab="ChIP-chip binding values for CBF1 (sig=-log10(N*P-value))",
     ylab="MET prediction (post. proba.)"
     )
setwd(dir.figures); export.plot(file.prefix='MET_pred_post__vs__CBF1_Lee_sig', export.formats=export.formats.plots, width=8,height=8)


## Met4p ChIP-chip versus CBF1 ChIP-chip
plot(comparison[,c("chip2.sig.CBF1","chip2.sig.MET4")],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=comparison.palette["MET"],lwd=2),
       abline(v=0,col=comparison.palette["MET"],lwd=2)
       ),
     xlab="ChIP-chip binding values for CBF1 (sig=-log10(N*P-value))",
     ylab="ChIP-chip binding values for MET4 (sig=-log10(N*P-value))"
     )
setwd(dir.figures); export.plot(file.prefix='MET4_lee__vs__CBF1_Lee_sig', export.formats=export.formats.plots, width=8,height=8)

## PHO predictions versus PHO4 ChIP-chip
plot(comparison[,c("chip2.sig.PHO4","lda.matrix.scores.posterior.PHO")],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=comparison.palette["PHO"],lwd=2),
       abline(v=0,col=comparison.palette["PHO"],lwd=2)
       ),
     xlab="ChIP-chip binding values for PHO4 (sig=-log10(N*P-value))",
     ylab="PHO prediction (post. proba.)"
     )
setwd(dir.figures); export.plot(file.prefix='PHO_pred_post__vs__PHO4_Lee_sig', export.formats=export.formats.plots, width=8,height=8)

# ## PHO predictions vs chip vs expression, sig
# plot(comparison[,c("chip2.sig.PHO4","lda.expression.sig.PHO","lda.matrix.scores.sig.PHO")],
#      col=group.colors,
#     cex=2,
#     cex.lab=1.4,
#      pch=group.pch)
# setwd(dir.figures); export.plot(file.prefix='PHO_predictions_Lee__vs___expression.sig', export.formats=export.formats.plots, width=8,height=8)

# ################################################################
# ## PHO predictions vs chip vs expression, probabilities
# plot(comparison[,c("chip2.sig.PHO4",
# 		   "ogawa.z.mean",
#                    #"lda.expression.posterior.PHO",
# 		   "lda.matrix.scores.posterior.PHO")],
#      col=group.colors,
#     cex=2,
#     cex.lab=1.4,
#      pch=group.pch
#      )
# setwd(dir.figures); export.plot(file.prefix='PHO4_Lee_sig__vs__expression_predictions', export.formats=export.formats.plots, width=8,height=8)

################################################################
## PHO lee vs expression
plot(comparison[,c("chip2.sig.PHO4",
		   "ogawa.z.mean"
		   )],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     xlab="ChIP-chip sig PHO4 (Lee 2002)",
     ylab="Phosphate response  microarrays (Ogawa 2000)",
     panel.first=c(
       grid(col='#000000'),
       abline(v=0,col=comparison.palette["PHO"],lwd=2)
       )
     )
if (!bw) {legend(0,10,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO4_Lee_sig__vs__Ogawa_expression', export.formats=export.formats.plots, width=8,height=8)

################################################################
## PHO lee vs matrix scores
plot(comparison[,c("chip2.sig.PHO4",
		   "lda.matrix.scores.posterior.PHO"
		   )],
     col=group.colors,
    cex=2,
    cex.lab=1.4,
     xlab="ChIP-chip sig Pho4p (Lee 2002)",
     ylab="Matrix scores (PHO posterior probability)",
     pch=group.pch,
     panel.first=c(grid(col='#000000'),
       abline(v=0,col=comparison.palette["PHO"],lwd=2),
       abline(h=0.5,col=comparison.palette["PHO"],lwd=2)
       )
     )
if (!bw) {legend(0,0.8,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO4_Lee_sig__vs__PHO_pred_post', export.formats=export.formats.plots, width=8,height=8)

################################################################
## PHO expression vs matrix scores

## First PCA component versus matrix scores
plot(comparison[,c( "ogawa.PC1",
		   "lda.matrix.scores.posterior.PHO"
		   )],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     xlab="Phosphate response microarrays (Ogawa 2000), 1st component after PCA",
     ylab="Matrix scores (PHO posterior probability)",
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=comparison.palette["PHO"],lwd=2)
       )
     )
if (!bw) {legend(10,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO_expression_PC1___vs__PHO_pred_post', export.formats=export.formats.plots, width=8,height=8)

################################################################
## mean expression per gene versus PHO posterior probability
plot(comparison[,c( "ogawa.z.mean",
		   "lda.matrix.scores.posterior.PHO"
		   )],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     xlab="Phosphate response microarrays (Ogawa 2000)",
     ylab="Matrix scores (PHO posterior probability)",
     panel.first=c(
       grid(col='#000000'),
       abline(v=0,col=abline.color, lwd=2),
       abline(h=0.5,col=comparison.palette["PHO"],lwd=2)
       )
     )
if (!bw) {legend(10,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO_expression_mean___vs__PHO_pred_post', export.formats=export.formats.plots, width=8,height=8)


## Plot the two first components of gene expression data
plot(comparison$ogawa.PC1,
     comparison$ogawa.PC2,
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     main="Phosphate response microarrays (Ogawa 2000)",
     xlab="First component",
     ylab="Second component",
     panel.first=c(
       grid(col='#000000'),
       abline(h=0,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2),
       )
     )
if (!bw) {legend(-30,-20,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO_expression_PC1__vs__PC2', export.formats=export.formats.plots, width=8,height=8)

## first component versus expression mean
plot(comparison[,c( "ogawa.PC1",
                    "ogawa.z.mean"
		   )],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     xlab="Phosphate response (Ogawa 2000) - PC1",
     ylab="Phosphate response (Ogawa 2000) - mean",
     panel.first=c(
       grid(col='#000000'),
       abline(h=0,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2),
       )
     )
if (!bw) {legend(10,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO_expression_PC1_vs__mean', export.formats=export.formats.plots, width=8,height=8)


################################################################
## MET versus PHO predictions

## MET vs PHO predictions: Posterior probabilities
plot(comparison[,c( "lda.matrix.scores.posterior.PHO", "lda.matrix.scores.posterior.MET")],
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0.5,col=abline.color,lwd=2)),
     col=group.colors)
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO_pred_post__vs__MET_pred_post', export.formats=export.formats.plots, width=8,height=8)

## Post.proba.PHO expression versus Post.proba.PHO matrix scores
plot(comparison[,c( "lda.matrix.scores.posterior.PHO", "lda.expression.posterior.PHO")],
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     col=group.colors)
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}

par(mai=c(1,1,1,1))

################################################################
## Comapre Harbison data to the other results


## Include  Harbison  in the comparison table
harbison.and.compa <- intersect(row.names(comparison),row.names(harbison.Pval))
print (paste("Common genes between Harbison and the comparison", length(harbison.and.compa)))
comparison <- cbind(comparison[,], harbison.Pval[row.names(comparison),])
comparison <- cbind(comparison[,], harbison.sig[row.names(comparison),])


## PHO4 Lee versus PHO4 Harbison (should be the same)
plot(comparison[,c( "chip2.sig.PHO4", "harbison.sig.PHO4_YPD")],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig PHO4 (Lee 2002)",
     ylab="ChIP-chip sig PHO4 on YPD (Harbison 2004)"     
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Lee_sig_PHO4___vs__Harbison_sig_PHO4_YPD', export.formats=export.formats.plots, width=8,height=8)


## Harbison : PHO4 YPD versus PHO4 Pi-
plot(comparison[,c("harbison.sig.PHO4_YPD", "harbison.sig.PHO4_Pi.")],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig PHO4 on YPD (Harbison 2004)",
     ylab="ChIP-chip sig PHO4 on Pi- medium (Harbison 2004)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_PHO4_YPD__vs__Harbison_sig_PHO4_Pi-', export.formats=export.formats.plots, width=8,height=8)


## Harbison PHO4 Pi- versus PHO predictions
plot(comparison[,c("harbison.sig.PHO4_Pi.", "lda.matrix.scores.posterior.PHO" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig PHO4 on Pi- medium (Harbison 2004)",
     ylab="PHO predictions (post. proba)"
     )

## Mark the P-value pf 10^-3 (note that this threshold is too permissive, it gives 6FP per chip)
#low.sig.th <- -log10(0.001*nrow(harbison.Pval))
#abline(v=low.sig.th,col="black")

if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_PHO4_Pi.__vs__PHO_pred_post', export.formats=export.formats.plots, width=8,height=8)


## Harbison MET4 YPD versus Harbison MET4 SM
plot(comparison[,c("harbison.sig.MET4_YPD", "harbison.sig.MET4_SM" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig MET4 on YPD medium (Harbison 2004)",
     ylab="ChIP-chip sig MET4 on SM medium (Harbison 2004)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_MET4_YPD__vs__Harbison_sig_MET4_SM', export.formats=export.formats.plots, width=8,height=8)

## Harbison MET4 YPD versus MET predictions
plot(comparison[,c("harbison.sig.MET4_YPD", "lda.matrix.scores.posterior.MET" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig MET4 on YPD medium (Harbison 2004)",
     ylab="MET predictions (post. proba)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_MET4_YPD__vs__MET_pred_post', export.formats=export.formats.plots, width=8,height=8)


## Harbison MET4 SM versus MET predictions
plot(comparison[,c("harbison.sig.MET4_SM", "lda.matrix.scores.posterior.MET" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig MET4 on SM medium (Harbison 2004)",
     ylab="MET predictions (post. proba)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_MET4_SM__vs__MET_pred_post', export.formats=export.formats.plots, width=8,height=8)


## Harbison MET32 YPD versus MET predictions
plot(comparison[,c("harbison.sig.MET32_YPD", "lda.matrix.scores.posterior.MET" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig MET32 on YPD medium (Harbison 2004)",
     ylab="MET predictions (post. proba)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_MET32_YPD__vs__MET_pred_post', export.formats=export.formats.plots, width=8,height=8)

## Harbison MET32 SM versus MET predictions
plot(comparison[,c("harbison.sig.MET32_SM", "lda.matrix.scores.posterior.MET" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig MET32 on SM medium (Harbison 2004)",
     ylab="MET predictions (post. proba)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_MET32_SM__vs__MET_pred_post', export.formats=export.formats.plots, width=8,height=8)


## Harbison MET31 YPD versus MET predictions
plot(comparison[,c("harbison.sig.MET31_YPD", "lda.matrix.scores.posterior.MET" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig MET31 on YPD medium (Harbison 2004)",
     ylab="MET predictions (post. proba)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_MET31_YPD__vs__MET_pred_post', export.formats=export.formats.plots, width=8,height=8)


## Harbison MET31 SM versus MET predictions
plot(comparison[,c("harbison.sig.MET31_SM", "lda.matrix.scores.posterior.MET" )],
     col=group.colors,
     pch=group.pch,
     cex=2,
     cex.lab=1.4,
     panel.first=c(
       grid(col='#000000'),
       abline(h=0.5,col=abline.color,lwd=2),
       abline(v=0,col=abline.color,lwd=2)),
     xlab="ChIP-chip sig MET31 on SM medium (Harbison 2004)",
     ylab="MET predictions (post. proba)"
     )
if (!bw) {legend(0.5,0.5,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='Harbison_sig_MET31_SM__vs__MET_pred_post', export.formats=export.formats.plots, width=8,height=8)

################################################################
## PHO Harbison vs expression
plot(comparison[,c("harbison.sig.PHO4_Pi.",
		   "ogawa.z.mean"
		   )],
     col=group.colors,
     cex=2,
     cex.lab=1.4,
     pch=group.pch,
     xlab="ChIP-chip PHO4 on Pi- medium (Harbison 2004)",
     ylab="Phosphate response microarrays (Ogawa 2000)",
     panel.first=c(
       grid(col='#000000'),
       abline(v=0,col=comparison.palette["PHO"],lwd=2)
       )
     )
if (!bw) {legend(0,10,legend=names(comparison.palette),lwd=2,col=comparison.palette)}
setwd(dir.figures); export.plot(file.prefix='PHO4_Pi.Harbison_sig__vs__Ogawa_expression', export.formats=export.formats.plots, width=8,height=8)

# ################################################################
# ## Select some genes
# comparison[!is.na(comparison$group.labels) 
#            & comparison$group.labels=="PHO"
#            & comparison$ogawa.z.mean < 3
#            & comparison$lda.matrix.scores.posterior.PHO > 0.5
#            ,"gene"]


verbose ("ALL PLOTS DONE")
